﻿using Edu.Library.Collections;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Edu.Library.Helpers
{
    public static class EsyFile
    {
        public static EsyStringList Read(string file)
        {
            var lines = File.ReadLines(file);
            var result = lines
                .Select(l => l.Trim())
                .ToList();
            var esyResult = new EsyStringList(result);
            return esyResult;
        }

        public static void Write(string file, string text)
        {
            File.WriteAllText(file, text);
        }

        public static void Write(string file, IEnumerable<string> lines)
        {
            var sb = new StringBuilder();
            foreach (var line in lines)
            {
                sb.AppendLine(line);
            }
            File.WriteAllText(file, sb.ToString());
        }

        public static void AppendLine(string file, string text) 
        {
            string[] line = { text };
            File.AppendAllLines(file, line);
        }
    }
}
